<?php
require_once '../config.php';
verificarLogin();

if ($_SESSION['usuario_tipo'] != 'admin') {
    header("Location: ../index.php");
    exit();
}

$security = new Security($pdo);
$id = $_GET['id'];

// Verificar CSRF
if (!isset($_GET['csrf_token']) || !$security->verifyCSRFToken($_GET['csrf_token'])) {
    die("Token CSRF inválido!");
}

// Impedir que o usuário exclua a si mesmo
if ($id == $_SESSION['usuario_id']) {
    header("Location: usuarios.php?erro=1");
    exit();
}

try {
    // Registrar na auditoria antes de excluir
    $stmt = $pdo->prepare("INSERT INTO security_logs (usuario_id, acao, ip_address, user_agent) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_SESSION['usuario_id'], 'excluir_usuario', $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']]);
    
    $stmt = $pdo->prepare("DELETE FROM usuarios WHERE id = ?");
    $stmt->execute([$id]);
    
    header("Location: usuarios.php?sucesso=1");
    exit();
} catch (PDOException $e) {
    header("Location: usuarios.php?erro=1");
    exit();
}
?>